<?php
session_start();
require 'db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

if (!isset($_GET['task_id'])) {
    die("Uzdevums nav norādīts.");
}

$task_id = intval($_GET['task_id']);

// Pārbaudām, vai lietotājam ir piekļuve uzdevumam
$stmt = $pdo->prepare("SELECT * FROM tasks WHERE id = ? AND calendar_id IN (SELECT id FROM calendars WHERE user_id = ?)");
$stmt->execute([$task_id, $_SESSION['user_id']]);
$task = $stmt->fetch();

if (!$task) {
    die("Jums nav piekļuves šim uzdevumam.");
}

// Dzēšam uzdevumu
$stmt = $pdo->prepare("DELETE FROM tasks WHERE id = ?");
$stmt->execute([$task_id]);

header("Location: dashboard.php");
exit();
?>
